<?php
// admin/index.php
require_once '../includes/functions.php';

// التحقق من تسجيل الدخول
if(!isLoggedIn()) redirect('login.php');

// ============================================================
// [إضافة 1] تشغيل نظام الإضافات (عشان أزرار البلوجينات تظهر في السايدبار)
// ============================================================
if (file_exists('../includes/plugin_system.php')) {
    include_once '../includes/plugin_system.php';
}

// 1. جلب إحصائيات المنتجات
 $products_count = 0;
 $active_products = 0;
try {
    $products_count = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();
    $active_products = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn(); // بما أننا لم نضف عمود active بعد، نعد الكل
} catch(Exception $e) {}

 $currency = getSetting('currency');

// 2. جلب إحصائيات الإضافات (بشكل آمن)
 $active_plugins_count = 0;
try {
    $check_plugins = $pdo->query("SHOW TABLES LIKE 'app_plugins'");
    if($check_plugins->rowCount() > 0) {
        $active_plugins_count = $pdo->query("SELECT COUNT(*) FROM app_plugins WHERE is_active = 1")->fetchColumn();
    }
} catch(Exception $e) {}

// 3. جلب إحصائيات الصور (الجديدة)
 $gallery_count = 0;
try {
    $check_gallery = $pdo->query("SHOW TABLES LIKE 'product_gallery'");
    if($check_gallery->rowCount() > 0) {
        $gallery_count = $pdo->query("SELECT COUNT(*) FROM product_gallery")->fetchColumn();
    }
} catch(Exception $e) {}

// 4. جلب إحصائيات الطلبات (لو الجدول موجود)
 $orders_count = 0;
try {
    $check_orders = $pdo->query("SHOW TABLES LIKE 'orders'");
    if($check_orders->rowCount() > 0) {
        $orders_count = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();
    }
} catch(Exception $e) {}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لوحة التحكم - الرئيسية</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>body { font-family: 'Cairo', sans-serif; }</style>
    <!-- إضافة مكتبة Alpine.js للتعامل مع الواجهة التفاعلية -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js"></script>
</head>
<!-- x-data لإدارة حالة القائمة في الموبايل -->
<body class="bg-gray-100 text-gray-800" x-data="{ sidebarOpen: false }">

<div class="flex h-screen overflow-hidden">
    
    <!-- === BACKDROP (خلفية القائمة للموبايل) === -->
    <div x-show="sidebarOpen" x-transition.opacity class="fixed inset-0 bg-black/50 z-40 md:hidden" @click="sidebarOpen = false"></div>

    <!-- Sidebar (القائمة الجانبية) -->
    <!-- md:static = ثابت في الشاشات الكبيرة -->
    <!-- fixed = ثابت للموبايل للتنقل -->
    <aside 
         class="fixed inset-y-0 right-0 z-50 w-64 bg-gray-900 text-white transform transition-transform duration-300 ease-in-out md:translate-x-0 md:static md:inset-0 md:flex flex-col shadow-2xl"
         :class="sidebarOpen ? 'translate-x-0' : 'translate-x-full'">
        
        <div class="h-20 flex items-center justify-center border-b border-gray-800 bg-gray-900">
            <h2 class="text-2xl font-bold text-emerald-400">WhatsCart</h2>
        </div>
        
        <nav class="flex-1 px-4 py-6 space-y-2 overflow-y-auto">
            <a href="index.php" class="flex items-center gap-3 px-4 py-3 bg-emerald-600 text-white rounded-xl shadow-lg shadow-emerald-900/20 transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2z" /></svg>
                الرئيسية
            </a>

            <a href="products.php" class="flex items-center gap-3 px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-xl transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" /></svg>
                المنتجات
            </a>
            
            <a href="plugins.php" class="flex items-center gap-3 px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-xl transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a2 2 0 012 2v6a2 2 0 01-2 2H9a2 2 0 01-2-2V6a2 2 0 012-2h2.5L11 4zm5 4h.01M8 16h.01" /></svg>
                الإضافات
            </a>

            <?php if(function_exists('do_action')) do_action('admin_sidebar'); ?>
            
            <div class="border-t border-gray-800 my-2"></div>

            <a href="settings.php" class="flex items-center gap-3 px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-xl transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 01-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                الإعدادات
            </a>
        </nav>

        <div class="p-4 border-t border-gray-800">
            <a href="logout.php" class="flex items-center gap-2 text-red-400 hover:text-red-300 transition text-sm font-bold">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" /></svg>
                تسجيل خروج
            </a>
        </div>
    </aside>

    <!-- Main Content (المحتوى الرئيسي) -->
    <main class="flex-1 overflow-y-auto relative w-full">
        
        <!-- Mobile Header (الهيدر للموبايل) -->
        <div class="md:hidden bg-white border-b border-gray-200 p-4 flex justify-between items-center sticky top-0 z-30 shadow-sm">
            <div class="flex items-center gap-3">
                <!-- زر فتح القائمة (هامبرغر) -->
                <button @click="sidebarOpen = true" class="p-2 rounded-lg hover:bg-gray-100 transition text-gray-700">
                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" /></svg>
                </button>
                <span class="font-bold text-lg text-gray-800">لوحة التحكم</span>
            </div>
            <!-- زر الخروج الموبايل -->
            <a href="logout.php" class="text-red-500 text-sm font-bold bg-red-50 px-3 py-2 rounded-lg hover:bg-red-100 transition">خروج</a>
        </div>

        <div class="p-6 md:p-10 max-w-7xl mx-auto">
            
            <h1 class="text-3xl font-extrabold text-gray-800 mb-2">لوحة المعلومات</h1>
            <p class="text-gray-500 mb-8">أهلاً بك، إليك نظرة سريعة على أداء متجرك اليوم.</p>
            
            <!-- الإحصائيات (Cards) -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
                
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center justify-between hover:shadow-md transition">
                    <div>
                        <p class="text-gray-500 text-sm font-bold mb-1">إجمالي المنتجات</p>
                        <h3 class="text-4xl font-extrabold text-gray-800"><?= $products_count ?></h3>
                    </div>
                    <div class="p-4 bg-blue-50 text-blue-600 rounded-xl shadow-sm">
                        <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" /></svg>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center justify-between hover:shadow-md transition">
                    <div>
                        <p class="text-gray-500 text-sm font-bold mb-1">صور المعرض</p>
                        <h3 class="text-4xl font-extrabold text-emerald-600"><?= $gallery_count ?></h3>
                    </div>
                    <div class="p-4 bg-emerald-50 text-emerald-600 rounded-xl shadow-sm">
                        <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" /></svg>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center justify-between hover:shadow-md transition">
                    <div>
                        <p class="text-gray-500 text-sm font-bold mb-1">إضافات نشطة</p>
                        <h3 class="text-4xl font-extrabold text-orange-600"><?= $active_plugins_count ?></h3>
                    </div>
                    <div class="p-4 bg-orange-50 text-orange-600 rounded-xl shadow-sm">
                        <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" /></svg>
                    </div>
                </div>

                <?php if ($orders_count > 0): ?>
                    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center justify-between hover:shadow-md transition">
                        <div>
                            <p class="text-gray-500 text-sm font-bold mb-1">الطلبات</p>
                            <h3 class="text-4xl font-extrabold text-indigo-600"><?= $orders_count ?></h3>
                        </div>
                        <div class="p-4 bg-indigo-50 text-indigo-600 rounded-xl shadow-sm">
                            <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" /></svg>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center justify-between hover:shadow-md transition">
                        <div>
                            <p class="text-gray-500 text-sm font-bold mb-1">العملة</p>
                            <h3 class="text-4xl font-extrabold text-purple-600"><?= $currency ?></h3>
                        </div>
                        <div class="p-4 bg-purple-50 text-purple-600 rounded-xl shadow-sm">
                            <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2c.895 0 2.08-.402 2.599-1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08.402-2.599 1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Action Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                
                <div class="bg-gradient-to-r from-emerald-600 to-teal-600 rounded-2xl p-8 text-white shadow-lg transform hover:-translate-y-1 transition duration-300">
                    <h3 class="text-2xl font-bold mb-3">معاينة المتجر</h3>
                    <p class="mb-6 opacity-90 leading-relaxed">شاهد التعديلات الجديدة، وتأكد من أن صفحة المنتجات والألبوم تظهر بشكل صحيح للعملاء.</p>
                    <a href="../index.php" target="_blank" class="inline-flex items-center gap-2 bg-white text-emerald-700 px-6 py-3 rounded-xl font-bold hover:bg-emerald-50 transition shadow-md">
                        زيارة المتجر
                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2V8a2 2 0 00-2-2H6a2 2 0 00-2 2v10a2 2 0 002 2z" /></svg>
                    </a>
                </div>
                
                <div class="bg-white rounded-2xl p-8 shadow-sm border border-gray-200 flex flex-col justify-center">
                    <h3 class="text-2xl font-bold text-gray-800 mb-2">إدارة سريعة</h3>
                    <p class="text-gray-500 mb-6">هل وصلك مخزون جديد؟ أضف منتجاتك وصورها المتعددة الآن.</p>
                    <div class="flex gap-3">
                        <a href="products.php" class="flex-1 bg-gray-900 text-white px-4 py-3 rounded-xl font-bold hover:bg-gray-800 transition text-center shadow-sm">
                            + إضافة منتج
                        </a>
                        <a href="settings.php" class="px-4 py-3 rounded-xl font-bold text-gray-600 border border-gray-300 hover:bg-gray-50 transition text-center">
                            الإعدادات
                        </a>
                    </div>
                </div>

            </div>

        </div>
    </main>
</div>

</body>
</html>