<?php
/*
Plugin Name: Theme Master Ultimate + Theme Manager
Plugin Key: theme_master_pro
Description: تخصيص كامل + نظام رفع ثيمات (ألوان، لوجو، فافيكون، بانرات، ومنتجات).
Version: 10.0 (With Theme Support)
*/

// ============================================================
// 1. إعداد قاعدة البيانات
// ============================================================
global $pdo;
if (isset($pdo)) {
    try {
        // جدول الإعدادات
        $pdo->exec("CREATE TABLE IF NOT EXISTS `tm_settings` (
            `setting_key` varchar(100) NOT NULL,
            `setting_value` text,
            PRIMARY KEY (`setting_key`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

        // جدول البانرات
        $pdo->exec("CREATE TABLE IF NOT EXISTS `tm_banners` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `position` varchar(50) NOT NULL,
            `image` varchar(255) NOT NULL,
            `link` varchar(255) DEFAULT NULL,
            `is_active` tinyint(1) DEFAULT 1,
            `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

        // القيم الافتراضية (تمت إضافة active_theme)
        $check = $pdo->query("SELECT count(*) FROM tm_settings")->fetchColumn();
        if ($check == 0) {
            $defaults = [
                'primary_color'   => '#10b981',
                'secondary_color' => '#3b82f6',
                'bg_color'        => '#f8fafc',
                'font_family'     => 'Cairo',
                'border_radius'   => '16px',
                'card_style'      => 'modern',
                'site_logo'       => '',
                'site_favicon'    => '',
                'active_theme'    => '' // المفتاح الجديد للثيم
            ];
            $stmt = $pdo->prepare("INSERT INTO tm_settings (setting_key, setting_value) VALUES (?, ?)");
            foreach ($defaults as $key => $val) {
                $stmt->execute([$key, $val]);
            }
        }
    } catch (PDOException $e) {}
}

// ============================================================
// 2. دوال المساعدة (Helpers)
// ============================================================

if (!function_exists('tm_get_opt')) {
    function tm_get_opt($key, $default = '') {
        global $pdo;
        if (!$pdo) return $default;
        try {
            $stmt = $pdo->prepare("SELECT setting_value FROM tm_settings WHERE setting_key = ?");
            $stmt->execute([$key]);
            $val = $stmt->fetchColumn();
            return $val !== false ? $val : $default;
        } catch (Exception $e) { return $default; }
    }
}

if (!function_exists('tm_upd_opt')) {
    function tm_upd_opt($key, $value) {
        global $pdo;
        if (!$pdo) return false;
        try {
            $stmt = $pdo->prepare("REPLACE INTO tm_settings (setting_key, setting_value) VALUES (?, ?)");
            return $stmt->execute([$key, $value]);
        } catch (Exception $e) { return false; }
    }
}

// ============================================================
// 3. القائمة الجانبية (Admin Sidebar)
// ============================================================
if (!function_exists('tm_sidebar_menu_fn')) {
    function tm_sidebar_menu_fn() {
        $active = (isset($_GET['tool']) && $_GET['tool'] == 'theme_master_pro') 
                  ? 'bg-gradient-to-l from-emerald-600 to-teal-500 text-white shadow-lg' 
                  : 'text-slate-400 hover:bg-slate-800 hover:text-white';
        
        $base = basename($_SERVER['PHP_SELF']); 
        $link = $base . '?tool=theme_master_pro';

        echo '<a href="'.$link.'" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all duration-300 '.$active.'">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                </svg>
                <span>مدير المظهر والثيمات</span>
              </a>';
    }
    add_action('admin_sidebar', 'tm_sidebar_menu_fn');
}

// ============================================================
// 4. صفحة الأدمن (Admin Page Logic)
// ============================================================
if (isset($_GET['tool']) && $_GET['tool'] == 'theme_master_pro') {
    tm_render_admin_page_fn();
    exit;
}

function tm_render_admin_page_fn() {
    global $pdo;
    $msg = '';
    $msg_type = '';

    // حفظ الإعدادات العامة
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_settings'])) {
        tm_upd_opt('primary_color', $_POST['primary_color']);
        tm_upd_opt('secondary_color', $_POST['secondary_color']);
        tm_upd_opt('bg_color', $_POST['bg_color']);
        tm_upd_opt('font_family', $_POST['font_family']);
        tm_upd_opt('border_radius', $_POST['border_radius']);
        tm_upd_opt('card_style', $_POST['card_style']);

        // رفع اللوجو
        if (!empty($_FILES['site_logo']['name'])) {
            $ext = strtolower(pathinfo($_FILES['site_logo']['name'], PATHINFO_EXTENSION));
            if (in_array($ext, ['png','jpg','jpeg','svg','webp'])) {
                $n = 'logo_'.uniqid().'.'.$ext;
                if(move_uploaded_file($_FILES['site_logo']['tmp_name'], "../assets/uploads/$n")) tm_upd_opt('site_logo', $n);
            }
        }
        // رفع الفافيكون
        if (!empty($_FILES['site_favicon']['name'])) {
            $ext = strtolower(pathinfo($_FILES['site_favicon']['name'], PATHINFO_EXTENSION));
            if (in_array($ext, ['png','ico','jpg'])) {
                $n = 'fav_'.uniqid().'.'.$ext;
                if(move_uploaded_file($_FILES['site_favicon']['tmp_name'], "../assets/uploads/$n")) tm_upd_opt('site_favicon', $n);
            }
        }

        $msg = "تم تحديث الإعدادات العامة بنجاح! 🎨";
        $msg_type = "success";
    }

    // --- إدارة الثيمات (جديد) ---
    // رفع الثيم
    if (isset($_POST['upload_theme']) && !empty($_FILES['theme_file']['name'])) {
        $ext = strtolower(pathinfo($_FILES['theme_file']['name'], PATHINFO_EXTENSION));
        // يسمح فقط بملفات PHP لضمان الكود الديناميكي
        if (in_array($ext, ['php'])) {
            $theme_dir = "../assets/themes/";
            if (!is_dir($theme_dir)) mkdir($theme_dir, 0755, true);
            
            $n = 'theme_'.uniqid().'.'.$ext;
            if(move_uploaded_file($_FILES['theme_file']['tmp_name'], $theme_dir.$n)) {
                tm_upd_opt('active_theme', $n);
                $msg = "تم تفعيل الثيم الجديد بنجاح! 🚀";
                $msg_type = "success";
            } else {
                $msg = "فشل رفع ملف الثيم";
                $msg_type = "error";
            }
        } else {
            $msg = "يجب أن يكون ملف الثيم بصيغة PHP فقط";
            $msg_type = "error";
        }
    }

    // حذف/إيقاف الثيم
    if (isset($_POST['reset_theme'])) {
        $current = tm_get_opt('active_theme');
        if ($current && file_exists("../assets/themes/$current")) {
            unlink("../assets/themes/$current");
        }
        tm_upd_opt('active_theme', '');
        $msg = "تم العودة للتصميم الافتراضي";
        $msg_type = "success";
    }

    // رفع بانر
    if (isset($_POST['upload_banner']) && !empty($_FILES['banner_img']['name'])) {
        $ext = strtolower(pathinfo($_FILES['banner_img']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp', 'gif'])) {
            $n = 'ban_' . uniqid() . '.' . $ext;
            if (move_uploaded_file($_FILES['banner_img']['tmp_name'], "../assets/uploads/$n")) {
                $stmt = $pdo->prepare("INSERT INTO tm_banners (position, image, link) VALUES (?, ?, ?)");
                $stmt->execute([$_POST['position'], $n, $_POST['link']]);
                $msg = "تم رفع البانر!";
                $msg_type = "success";
            }
        }
    }

    // حذف بانر
    if (isset($_GET['delete_banner'])) {
        $id = (int)$_GET['delete_banner'];
        $pdo->prepare("DELETE FROM tm_banners WHERE id = ?")->execute([$id]);
        echo "<script>window.location='?tool=theme_master_pro';</script>";
        exit;
    }

    $s = [
        'p'   => tm_get_opt('primary_color', '#10b981'),
        'sec' => tm_get_opt('secondary_color', '#3b82f6'),
        'bg'  => tm_get_opt('bg_color', '#f8fafc'),
        'f'   => tm_get_opt('font_family', 'Cairo'),
        'r'   => tm_get_opt('border_radius', '16px'),
        'card'=> tm_get_opt('card_style', 'modern'),
        'logo'=> tm_get_opt('site_logo', ''),
        'fav' => tm_get_opt('site_favicon', ''),
        'theme' => tm_get_opt('active_theme', '')
    ];
    
    $banners = $pdo->query("SELECT * FROM tm_banners ORDER BY id DESC")->fetchAll();
    ?>

    <!DOCTYPE html>
    <html lang="ar" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <title>مدير المظهر والثيمات</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
        <style>body { font-family: 'Cairo', sans-serif; background: #f1f5f9; }</style>
    </head>
    <body class="bg-slate-50 text-slate-800 p-6">
        <div class="max-w-7xl mx-auto">
            
            <header class="flex justify-between items-center mb-8 bg-white p-4 rounded-2xl shadow-sm border border-slate-200">
                <div class="flex items-center gap-3">
                    <span class="text-2xl">🎨</span>
                    <h1 class="text-xl font-bold">لوحة التحكم في المظهر والثيمات</h1>
                </div>
                <a href="plugins.php" class="px-4 py-2 bg-gray-100 rounded-lg text-sm font-bold text-gray-600">عودة</a>
            </header>

            <?php if($msg): ?>
                <div class="mb-6 p-4 rounded-xl text-white font-bold text-center <?= $msg_type=='success'?'bg-emerald-500':'bg-red-500' ?>"><?= $msg ?></div>
            <?php endif; ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                
                <div class="lg:col-span-2 space-y-6">
                    
                    <!-- 1. قسم الثيمات (جديد) -->
                    <div class="bg-gradient-to-r from-indigo-500 to-purple-600 p-6 rounded-2xl shadow-lg text-white relative overflow-hidden">
                        <div class="absolute top-0 left-0 w-32 h-32 bg-white opacity-10 rounded-full -ml-10 -mt-10"></div>
                        <h3 class="text-xl font-bold mb-4 flex items-center gap-2">🌟 إدارة الثيم (الصفحة الرئيسية)</h3>
                        <p class="text-sm opacity-90 mb-4">قم برفع ملف تصميم (PHP) ليتم تطبيقه على الصفحة الرئيسية بدلاً من التصميم الافتراضي.</p>
                        
                        <?php if($s['theme']): ?>
                            <div class="bg-white/10 backdrop-blur-sm p-4 rounded-xl border border-white/20 mb-4">
                                <p class="font-bold text-sm mb-1">الثيم النشط حالياً:</p>
                                <p class="text-xs opacity-80 font-mono break-all"><?= $s['theme'] ?></p>
                                <form method="POST" class="mt-3">
                                    <button type="submit" name="reset_theme" class="bg-red-500 hover:bg-red-600 text-white text-xs px-3 py-1 rounded-lg transition">إيقاف الثيم والعودة للافتراضي</button>
                                </form>
                            </div>
                        <?php endif; ?>

                        <form method="POST" enctype="multipart/form-data" class="bg-white/10 p-4 rounded-xl">
                            <label class="block text-sm font-bold mb-2">اختر ملف الثيم (.php):</label>
                            <input type="file" name="theme_file" accept=".php" class="block w-full text-sm text-slate-900 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 mb-3">
                            <button type="submit" name="upload_theme" class="w-full bg-white text-indigo-600 font-bold py-2 rounded-lg hover:bg-gray-100 transition">رفع وتفعيل الثيم</button>
                        </form>
                    </div>

                    <!-- 2. الإعدادات العامة -->
                    <form method="POST" enctype="multipart/form-data" class="bg-white p-6 rounded-2xl shadow-sm border border-slate-200 space-y-6">
                        
                        <div class="grid grid-cols-2 gap-6 pb-6 border-b">
                            <div>
                                <label class="block text-sm font-bold mb-2">لوجو الموقع</label>
                                <?php if($s['logo']): ?><img src="../assets/uploads/<?= $s['logo'] ?>" class="h-10 mb-2 border p-1 rounded"><?php endif; ?>
                                <input type="file" name="site_logo" class="block w-full text-sm border rounded p-1">
                            </div>
                            <div>
                                <label class="block text-sm font-bold mb-2">أيقونة المتصفح (Favicon)</label>
                                <?php if($s['fav']): ?><img src="../assets/uploads/<?= $s['fav'] ?>" class="h-8 mb-2 border p-1 rounded"><?php endif; ?>
                                <input type="file" name="site_favicon" class="block w-full text-sm border rounded p-1">
                            </div>
                        </div>

                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="text-xs font-bold text-gray-500">اللون الأساسي</label>
                                <input type="color" name="primary_color" value="<?= $s['p'] ?>" class="w-full h-10 rounded cursor-pointer border">
                            </div>
                            <div>
                                <label class="text-xs font-bold text-gray-500">اللون الثانوي</label>
                                <input type="color" name="secondary_color" value="<?= $s['sec'] ?>" class="w-full h-10 rounded cursor-pointer border">
                            </div>
                            <div>
                                <label class="text-xs font-bold text-gray-500">الخلفية</label>
                                <input type="color" name="bg_color" value="<?= $s['bg'] ?>" class="w-full h-10 rounded cursor-pointer border">
                            </div>
                        </div>

                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="text-xs font-bold text-gray-500">الخط</label>
                                <select name="font_family" class="w-full border p-2 rounded-lg bg-gray-50">
                                    <option value="Cairo" <?= $s['f']=='Cairo'?'selected':'' ?>>Cairo</option>
                                    <option value="Tajawal" <?= $s['f']=='Tajawal'?'selected':'' ?>>Tajawal</option>
                                    <option value="Almarai" <?= $s['f']=='Almarai'?'selected':'' ?>>Almarai</option>
                                </select>
                            </div>
                            <div>
                                <label class="text-xs font-bold text-gray-500">استدارة الحواف</label>
                                <select name="border_radius" class="w-full border p-2 rounded-lg bg-gray-50">
                                    <option value="0px" <?= $s['r']=='0px'?'selected':'' ?>>0px</option>
                                    <option value="8px" <?= $s['r']=='8px'?'selected':'' ?>>8px</option>
                                    <option value="16px" <?= $s['r']=='16px'?'selected':'' ?>>16px</option>
                                </select>
                            </div>
                            <div>
                                <label class="text-xs font-bold text-gray-500">شكل المنتجات</label>
                                <select name="card_style" class="w-full border p-2 rounded-lg bg-gray-50">
                                    <option value="modern" <?= $s['card']=='modern'?'selected':'' ?>>عصري</option>
                                    <option value="classic" <?= $s['card']=='classic'?'selected':'' ?>>كلاسيك</option>
                                    <option value="minimal" <?= $s['card']=='minimal'?'selected':'' ?>>بسيط</option>
                                </select>
                            </div>
                        </div>

                        <button type="submit" name="save_settings" class="w-full bg-slate-800 text-white py-3 rounded-xl font-bold hover:bg-black transition">حفظ التعديلات</button>
                    </form>
                </div>

                <!-- 3. البانرات -->
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-200">
                    <h3 class="font-bold text-lg mb-4 text-gray-700">إدارة البانرات</h3>
                    <form method="POST" enctype="multipart/form-data" class="space-y-3 mb-6">
                        <select name="position" class="w-full border rounded-lg p-2 text-sm">
                            <option value="top_bar">أعلى الموقع</option>
                            <option value="hero">سلايدر الرئيسية</option>
                            <option value="middle">وسط المنتجات</option>
                        </select>
                        <input type="file" name="banner_img" required class="w-full text-sm border rounded-lg p-1">
                        <input type="url" name="link" placeholder="الرابط" class="w-full text-sm border rounded-lg p-2 dir-ltr">
                        <button type="submit" name="upload_banner" class="w-full bg-emerald-600 text-white py-2 rounded-lg font-bold hover:bg-emerald-700">رفع صورة</button>
                    </form>

                    <div class="space-y-2 max-h-80 overflow-y-auto">
                        <?php foreach($banners as $b): ?>
                        <div class="flex gap-2 bg-gray-50 p-2 rounded-lg border items-center">
                            <img src="../assets/uploads/<?= $b['image'] ?>" class="w-12 h-8 object-cover rounded">
                            <span class="text-xs bg-gray-200 px-2 py-1 rounded"><?= $b['position'] ?></span>
                            <a href="?tool=theme_master_pro&delete_banner=<?= $b['id'] ?>" onclick="return confirm('حذف؟')" class="mr-auto text-red-500">✕</a>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

            </div>
        </div>
    </body>
    </html>
    <?php
}

// ============================================================
// 5. الواجهة الأمامية (Front-end Logic)
// ============================================================

// دالة تشغيل الثيم (الجديدة)
if (!function_exists('tm_theme_loader_fn')) {
    function tm_theme_loader_fn() {
        $theme_file = tm_get_opt('active_theme', '');
        // التأكد من وجود الملف
        if ($theme_file && file_exists('assets/themes/' . $theme_file)) {
            // تضمين الملف مباشرة
            include 'assets/themes/' . $theme_file;
        }
    }
    // نقوم بتسجيل الهوك هنا، ويجب عليك استدعاؤه في الـ Index
    if (function_exists('add_action')) {
        add_action('custom_theme_view', 'tm_theme_loader_fn');
    }
}

// دالة تخصيص الألوان والخطوط
if (!function_exists('tm_frontend_inject_fn')) {
    function tm_frontend_inject_fn() {
        $p   = tm_get_opt('primary_color', '#10b981');
        $sec = tm_get_opt('secondary_color', '#3b82f6');
        $bg  = tm_get_opt('bg_color', '#f8fafc');
        $f   = tm_get_opt('font_family', 'Cairo');
        $r   = tm_get_opt('border_radius', '16px');
        $c   = tm_get_opt('card_style', 'modern');
        $fav = tm_get_opt('site_favicon', '');
        $logo= tm_get_opt('site_logo', '');

        // 1. الفافيكون
        if ($fav) echo '<link rel="icon" href="assets/uploads/'.$fav.'">';

        // 2. الخطوط
        $fonts = [
            'Cairo'   => 'https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap',
            'Tajawal' => 'https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap',
            'Almarai' => 'https://fonts.googleapis.com/css2?family=Almarai:wght@400;700&display=swap',
        ];
        echo "<link href='".($fonts[$f]??$fonts['Cairo'])."' rel='stylesheet'>";

        // 3. CSS
        ?>
        <style>
            :root {
                --tm-p: <?= $p ?>;
                --tm-bg: <?= $bg ?>;
                --tm-font: '<?= $f ?>', sans-serif;
                --tm-radius: <?= $r ?>;
            }
            body { font-family: var(--tm-font) !important; background-color: var(--tm-bg) !important; }
            .bg-white, nav.bg-white, .modal-content, input, select { background-color: #ffffff !important; }
            .text-emerald-600, .text-green-600, a.hover\:text-emerald-600:hover { color: var(--tm-p) !important; }
            .bg-emerald-600, .bg-gray-900, .btn-primary { background-color: var(--tm-p) !important; border-color: var(--tm-p) !important; }
            .border-emerald-500 { border-color: var(--tm-p) !important; }
            .rounded-xl, .rounded-lg, .rounded-2xl, .product-card, img, input, button { border-radius: var(--tm-radius) !important; }
            
            <?php if($c == 'modern'): ?>
                .product-card { border: none !important; box-shadow: 0 4px 20px rgba(0,0,0,0.05) !important; }
            <?php elseif($c == 'minimal'): ?>
                .product-card { border: 1px solid #f1f5f9 !important; box-shadow: none !important; background: transparent !important; }
            <?php endif; ?>
        </style>

        <?php if($logo): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const titles = document.querySelectorAll('h1.text-xl.font-bold');
                titles.forEach(el => {
                    el.innerHTML = '<img src="assets/uploads/<?= $logo ?>" alt="Logo" style="max-height: 50px; object-fit: contain;">';
                });
            });
        </script>
        <?php endif; ?>
        <?php
    }
    add_action('site_head', 'tm_frontend_inject_fn');
}

// دالة البانرات
if (!function_exists('tm_banners_display_fn')) {
    function tm_banners_display_fn($pos) {
        global $pdo;
        try {
            $stmt = $pdo->prepare("SELECT * FROM tm_banners WHERE position = ? AND is_active = 1 ORDER BY id DESC");
            $stmt->execute([$pos]);
            $banners = $stmt->fetchAll();

            if ($pos == 'hero' && !empty($banners)) {
                echo '<div class="relative w-full overflow-hidden mb-8 rounded-2xl shadow-lg group mx-auto max-w-6xl"><div class="flex overflow-x-auto snap-x snap-mandatory hide-scroll">';
                foreach ($banners as $b) {
                    $link_start = $b['link'] ? "<a href='{$b['link']}' target='_blank' class='snap-center min-w-full block'>" : "<div class='snap-center min-w-full block'>";
                    $link_end = $b['link'] ? "</a>" : "</div>";
                    echo $link_start;
                    echo "<img src='assets/uploads/{$b['image']}' class='w-full h-48 md:h-[400px] object-cover hover:scale-105 transition duration-700'>";
                    echo $link_end;
                }
                echo '</div></div>';
            } elseif (!empty($banners)) {
                foreach ($banners as $b) {
                    $link_start = $b['link'] ? "<a href='{$b['link']}' target='_blank' class='block'>" : "<div class='block'>";
                    $link_end = $b['link'] ? "</a>" : "</div>";
                    echo "<div class='w-full mb-6 rounded-2xl overflow-hidden shadow-sm hover:shadow-md transition mx-auto max-w-6xl'>";
                    echo $link_start;
                    echo "<img src='assets/uploads/{$b['image']}' class='w-full h-auto object-cover'>";
                    echo $link_end;
                    echo "</div>";
                }
            }
        } catch(Exception $e) {}
    }
}

// دوال الربط
if (!function_exists('tm_hook_top')) { function tm_hook_top() { tm_banners_display_fn('top_bar'); } }
if (!function_exists('tm_hook_hero')) { function tm_hook_hero() { tm_banners_display_fn('hero'); } }
if (!function_exists('tm_hook_mid')) { function tm_hook_mid() { tm_banners_display_fn('middle'); } }

if (function_exists('add_action')) {
    add_action('top_bar_ads', 'tm_hook_top');
    add_action('after_navbar', 'tm_hook_hero');
    add_action('before_products', 'tm_hook_mid');
}
?>